<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Gym extends Model
{
    use HasFactory;

    protected $fillable = [
        'photo1',
        'photo2',
        'photo3',
        'informations',
        'adresse',
        'tel',
        'email',
        'website',
        'specialite',
        'nationalite',
        'description',
        'validate',
    ];

    // Accessor pour limiter la description
    public function getShortDescriptionAttribute()
    {
        return Str::limit($this->description, 150);
    }

    // Accessor pour afficher les spécialités formatées
    public function getFormattedSpecialiteAttribute()
    {
        if (!$this->specialite) {
            return 'Not specified';
        }

        // Capitaliser chaque mot
        return ucwords(strtolower($this->specialite));
    }
}
